/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalManipulation {
    public static final DQuaternion flipAxisW = DQuaternion.rotationByDegrees(new Vec3(0.0, 1.0, 0.0), 180.0).fixFloatingPointErrorAccumulation();

    public static void setPortalTransformation(Portal portal, ResourceKey<Level> destDim, Vec3 destPos, @Nullable DQuaternion rotation, double scale) {
        portal.dimensionTo = destDim;
        portal.setDestination(destPos);
        portal.rotation = rotation;
        portal.scaling = scale;
        portal.updateCache();
    }

    public static void removeConnectedPortals(Portal portal, Consumer<Portal> removalInformer) {
        PortalManipulation.removeOverlappedPortals(portal.m_9236_(), portal.getOriginPos(), portal.getNormal().m_82490_(-1.0), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        ServerLevel toWorld = MiscHelper.getServer().m_129880_(portal.dimensionTo);
        PortalManipulation.removeOverlappedPortals((Level)toWorld, portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal().m_82490_(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        PortalManipulation.removeOverlappedPortals((Level)toWorld, portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal()), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
    }

    public static Portal completeBiWayPortal(Portal portal, EntityType<? extends Portal> entityType) {
        Portal newPortal = PortalManipulation.createReversePortal(portal, entityType);
        McHelper.spawnServerEntity(newPortal);
        return newPortal;
    }

    public static <T extends Portal> T createReversePortal(Portal portal, EntityType<T> entityType) {
        Level world = portal.getDestinationWorld();
        Portal newPortal = (Portal)entityType.m_20615_(world);
        newPortal.dimensionTo = portal.m_9236_().m_46472_();
        newPortal.m_6034_(portal.getDestPos().f_82479_, portal.getDestPos().f_82480_, portal.getDestPos().f_82481_);
        newPortal.setDestination(portal.getOriginPos());
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width * portal.scaling;
        newPortal.height = portal.height * portal.scaling;
        newPortal.axisW = portal.axisW.m_82490_(-1.0);
        newPortal.axisH = portal.axisH;
        if (portal.specialShape != null) {
            portal.specialShape.normalize(newPortal.width, newPortal.height);
            newPortal.specialShape = portal.specialShape.getFlippedWithScaling(1.0);
        }
        newPortal.initCullableRange(-portal.cullableXStart * portal.scaling, -portal.cullableXEnd * portal.scaling, portal.cullableYStart * portal.scaling, portal.cullableYEnd * portal.scaling);
        if (portal.rotation != null) {
            PortalManipulation.rotatePortalBody(newPortal, portal.rotation);
            newPortal.rotation = portal.rotation.getConjugated();
        }
        newPortal.scaling = 1.0 / portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return (T)newPortal;
    }

    public static void rotatePortalBody(Portal portal, DQuaternion rotation) {
        portal.axisW = rotation.rotate(portal.axisW);
        portal.axisH = rotation.rotate(portal.axisH);
    }

    public static Portal completeBiFacedPortal(Portal portal, EntityType<Portal> entityType) {
        Portal newPortal = PortalManipulation.createFlippedPortal(portal, entityType);
        McHelper.spawnServerEntity(newPortal);
        return newPortal;
    }

    public static <T extends Portal> T createFlippedPortal(Portal portal, EntityType<T> entityType) {
        Level world = portal.m_9236_();
        Portal newPortal = (Portal)entityType.m_20615_(world);
        newPortal.dimensionTo = portal.dimensionTo;
        newPortal.m_6034_(portal.m_20185_(), portal.m_20186_(), portal.m_20189_());
        newPortal.setDestination(portal.getDestPos());
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width;
        newPortal.height = portal.height;
        newPortal.axisW = portal.axisW.m_82490_(-1.0);
        newPortal.axisH = portal.axisH;
        if (portal.specialShape != null) {
            newPortal.specialShape = portal.specialShape.getFlippedWithScaling(1.0);
        }
        newPortal.initCullableRange(-portal.cullableXStart, -portal.cullableXEnd, portal.cullableYStart, portal.cullableYEnd);
        newPortal.rotation = portal.rotation;
        newPortal.scaling = portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return (T)newPortal;
    }

    public static Portal copyPortal(Portal portal, EntityType<Portal> entityType) {
        Level world = portal.m_9236_();
        Portal newPortal = (Portal)entityType.m_20615_(world);
        newPortal.dimensionTo = portal.dimensionTo;
        newPortal.m_6034_(portal.m_20185_(), portal.m_20186_(), portal.m_20189_());
        newPortal.setDestination(portal.getDestPos());
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width;
        newPortal.height = portal.height;
        newPortal.axisW = portal.axisW;
        newPortal.axisH = portal.axisH;
        newPortal.specialShape = portal.specialShape;
        newPortal.initCullableRange(portal.cullableXStart, portal.cullableXEnd, portal.cullableYStart, portal.cullableYEnd);
        newPortal.rotation = portal.rotation;
        newPortal.scaling = portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return newPortal;
    }

    public static void completeBiWayBiFacedPortal(Portal portal, Consumer<Portal> removalInformer, Consumer<Portal> addingInformer, EntityType<Portal> entityType) {
        PortalManipulation.removeOverlappedPortals((Level)((ServerLevel)portal.m_9236_()), portal.getOriginPos(), portal.getNormal().m_82490_(-1.0), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal oppositeFacedPortal = PortalManipulation.completeBiFacedPortal(portal, entityType);
        PortalManipulation.removeOverlappedPortals((Level)MiscHelper.getServer().m_129880_(portal.dimensionTo), portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal().m_82490_(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal r1 = PortalManipulation.completeBiWayPortal(portal, entityType);
        PortalManipulation.removeOverlappedPortals((Level)MiscHelper.getServer().m_129880_(oppositeFacedPortal.dimensionTo), oppositeFacedPortal.getDestPos(), oppositeFacedPortal.transformLocalVecNonScale(oppositeFacedPortal.getNormal().m_82490_(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal r2 = PortalManipulation.completeBiWayPortal(oppositeFacedPortal, entityType);
        addingInformer.accept(oppositeFacedPortal);
        addingInformer.accept(r1);
        addingInformer.accept(r2);
    }

    public static void removeOverlappedPortals(Level world, Vec3 pos, Vec3 normal, Predicate<Portal> predicate, Consumer<Portal> informer) {
        PortalManipulation.getPortalCluster(world, pos, normal, predicate).forEach(e -> {
            e.m_142687_(Entity.RemovalReason.KILLED);
            informer.accept((Portal)e);
        });
    }

    public static List<Portal> getPortalCluster(Level world, Vec3 pos, Vec3 normal, Predicate<Portal> predicate) {
        return McHelper.findEntitiesByBox(Portal.class, world, new AABB(pos.m_82520_(0.1, 0.1, 0.1), pos.m_82492_(0.1, 0.1, 0.1)), IPGlobal.maxNormalPortalRadius, p -> p.getNormal().m_82526_(normal) > 0.5 && predicate.test((Portal)p));
    }

    public static <T extends Portal> T createOrthodoxPortal(EntityType<T> entityType, ServerLevel fromWorld, ServerLevel toWorld, Direction facing, AABB portalArea, Vec3 destination) {
        Portal portal = (Portal)entityType.m_20615_((Level)fromWorld);
        PortalAPI.setPortalOrthodoxShape(portal, facing, portalArea);
        portal.setDestination(destination);
        portal.dimensionTo = toWorld.m_46472_();
        return (T)portal;
    }

    public static void copyAdditionalProperties(Portal to, Portal from) {
        PortalManipulation.copyAdditionalProperties(to, from, true);
    }

    public static void copyAdditionalProperties(Portal to, Portal from, boolean includeSpecialProperties) {
        to.teleportable = from.teleportable;
        to.teleportChangesScale = from.teleportChangesScale;
        to.teleportChangesGravity = from.teleportChangesGravity;
        to.specificPlayerId = from.specificPlayerId;
        PortalExtension.get((Portal)to).motionAffinity = PortalExtension.get((Portal)from).motionAffinity;
        PortalExtension.get((Portal)to).adjustPositionAfterTeleport = PortalExtension.get((Portal)from).adjustPositionAfterTeleport;
        to.hasCrossPortalCollision = from.hasCrossPortalCollision;
        PortalExtension.get((Portal)to).bindCluster = PortalExtension.get((Portal)from).bindCluster;
        to.animation.defaultAnimation = from.animation.defaultAnimation.copy();
        to.setIsVisible(from.isVisible());
        if (includeSpecialProperties) {
            to.portalTag = from.portalTag;
            to.commandsOnTeleported = from.commandsOnTeleported;
        }
    }

    public static void createScaledBoxView(ServerLevel areaWorld, AABB area, ServerLevel boxWorld, Vec3 boxBottomCenter, double scale, boolean biWay, boolean teleportChangesScale, boolean outerFuseView, boolean outerRenderingMergable, boolean innerRenderingMergable, boolean hasCrossPortalCollision) {
        Vec3 viewBoxSize = Helper.getBoxSize(area).m_82490_(1.0 / scale);
        AABB viewBox = Helper.getBoxByBottomPosAndSize(boxBottomCenter, viewBoxSize);
        for (Direction direction : Direction.values()) {
            Object portal = PortalManipulation.createOrthodoxPortal((EntityType)IPRegistry.PORTAL.get(), boxWorld, areaWorld, direction, Helper.getBoxSurface(viewBox, direction), Helper.getBoxSurface(area, direction).m_82399_());
            ((Portal)portal).scaling = scale;
            ((Portal)portal).teleportChangesScale = teleportChangesScale;
            ((Portal)portal).fuseView = outerFuseView;
            ((Portal)portal).renderingMergable = outerRenderingMergable;
            ((Portal)portal).hasCrossPortalCollision = hasCrossPortalCollision;
            ((Portal)portal).portalTag = "imm_ptl:scale_box";
            McHelper.spawnServerEntity(portal);
            if (!biWay) continue;
            Object reversePortal = PortalManipulation.createReversePortal(portal, (EntityType)IPRegistry.PORTAL.get());
            ((Portal)reversePortal).renderingMergable = innerRenderingMergable;
            McHelper.spawnServerEntity(reversePortal);
        }
    }

    public static Portal placePortal(double width, double height, Entity entity) {
        Vec3 playerLook = entity.m_20154_();
        Tuple<BlockHitResult, List<Portal>> rayTrace = IPMcHelper.rayTrace(entity.m_9236_(), new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(playerLook.m_82490_(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity), true);
        BlockHitResult hitResult = (BlockHitResult)rayTrace.m_14418_();
        List hitPortals = (List)rayTrace.m_14419_();
        if (IPMcHelper.hitResultIsMissedOrNull((HitResult)hitResult)) {
            return null;
        }
        for (Portal hitPortal : hitPortals) {
            playerLook = hitPortal.transformLocalVecNonScale(playerLook);
        }
        Direction lookingDirection = Helper.getFacingExcludingAxis(playerLook, hitResult.m_82434_().m_122434_());
        if (lookingDirection == null) {
            return null;
        }
        Vec3 axisH = Vec3.m_82528_((Vec3i)hitResult.m_82434_().m_122436_());
        Vec3 axisW = axisH.m_82537_(Vec3.m_82528_((Vec3i)lookingDirection.m_122424_().m_122436_()));
        Vec3 pos = Vec3.m_82512_((Vec3i)hitResult.m_82425_()).m_82549_(axisH.m_82490_(0.5 + height / 2.0));
        Level world = hitPortals.isEmpty() ? entity.m_9236_() : ((Portal)hitPortals.get(hitPortals.size() - 1)).getDestinationWorld();
        Portal portal = new Portal((EntityType)IPRegistry.PORTAL.get(), world);
        portal.m_20343_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        portal.axisW = axisW;
        portal.axisH = axisH;
        portal.width = width;
        portal.height = height;
        return portal;
    }

    public static DQuaternion getPortalOrientationQuaternion(Vec3 axisW, Vec3 axisH) {
        Vec3 normal = axisW.m_82537_(axisH);
        return DQuaternion.matrixToQuaternion(axisW, axisH, normal);
    }

    public static void setPortalOrientationQuaternion(Portal portal, DQuaternion quaternion) {
        portal.setOrientationRotation(quaternion);
    }

    public static void adjustRotationToConnect(Portal portalA, Portal portalB) {
        DQuaternion a = PortalAPI.getPortalOrientationQuaternion(portalA);
        DQuaternion b = PortalAPI.getPortalOrientationQuaternion(portalB);
        DQuaternion delta = b.hamiltonProduct(a.getConjugated());
        DQuaternion flip = DQuaternion.rotationByDegrees(portalB.axisH, 180.0);
        DQuaternion aRot = flip.hamiltonProduct(delta);
        portalA.setRotation(aRot);
        portalB.setRotation(aRot.getConjugated());
    }

    public static boolean isOtherSideBoxInside(AABB transformedBoundingBox, PortalLike renderingPortal) {
        boolean intersects = Arrays.stream(Helper.eightVerticesOf(transformedBoundingBox)).anyMatch(p -> renderingPortal.isOnDestinationSide((Vec3)p, 0.0));
        return intersects;
    }

    @Nullable
    public static Portal findParallelPortal(Portal portal) {
        return Helper.getFirstNullable(McHelper.findEntitiesRough(Portal.class, portal.getDestinationWorld(), portal.getDestPos(), 0, p1 -> p1.getOriginPos().m_82546_(portal.getDestPos()).m_82556_() < 0.01 && p1.getDestPos().m_82546_(portal.getOriginPos()).m_82556_() < 0.01 && p1.getNormal().m_82526_(portal.getContentDirection()) < -0.9 && p1.getContentDirection().m_82526_(portal.getNormal()) < -0.9 && !(p1 instanceof Mirror) && p1 != portal));
    }

    @Nullable
    public static Portal findReversePortal(Portal portal) {
        return Helper.getFirstNullable(McHelper.findEntitiesRough(Portal.class, portal.getDestinationWorld(), portal.getDestPos(), 0, p1 -> Portal.isReversePortal(portal, p1)));
    }

    @Nullable
    public static Portal findFlippedPortal(Portal portal) {
        return Helper.getFirstNullable(McHelper.findEntitiesRough(Portal.class, portal.getOriginWorld(), portal.getOriginPos(), 0, p1 -> p1.getOriginPos().m_82546_(portal.getOriginPos()).m_82556_() < 0.01 && p1.getNormal().m_82526_(portal.getNormal()) < -0.9 && p1.getDestPos().m_82557_(portal.getDestPos()) < 0.01 && !(p1 instanceof Mirror) && p1 != portal));
    }

    @Deprecated
    public static Optional<Pair<Portal, Vec3>> raytracePortals(Level world, Vec3 from, Vec3 to, boolean includeGlobalPortal) {
        return PortalCommand.raytracePortals(world, from, to, includeGlobalPortal);
    }

    public static DQuaternion computeDeltaTransformation(DQuaternion thisSideOrientation, DQuaternion otherSideOrientation) {
        return otherSideOrientation.hamiltonProduct(flipAxisW).hamiltonProduct(thisSideOrientation.getConjugated());
    }

    public static void makePortalRound(Portal portal, int triangleNum) {
        GeometryPortalShape shape = new GeometryPortalShape();
        double twoPi = Math.PI * 2;
        shape.triangles = IntStream.range(0, triangleNum).mapToObj(i -> new GeometryPortalShape.TriangleInPlane(0.0, 0.0, portal.width * 0.5 * Math.cos(twoPi * (double)i / (double)triangleNum), portal.height * 0.5 * Math.sin(twoPi * (double)i / (double)triangleNum), portal.width * 0.5 * Math.cos(twoPi * ((double)i + 1.0) / (double)triangleNum), portal.height * 0.5 * Math.sin(twoPi * ((double)i + 1.0) / (double)triangleNum))).collect(Collectors.toList());
        portal.specialShape = shape;
    }
}

